

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND4 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;